int pinVentola=11;
const float B = 3950;
const float R = 10000.0;
const float RT0 = 10000.0;
const float T0 = 298.15;
const float Vcc = 5.0;

//Variables
float Rs, VR, I, Ts, Vs;

void setup() 
{
  pinMode(pinVentola, OUTPUT);

  Serial.begin ( 9600);
}

void loop() 
{
  Vs = analogRead(A0); // 0-1023 tensione sul termistore
  Vs = (5.00 / 1023.00) * Vs; // converto in Volt
  VR = Vcc - Vs; // tensione sulla resistenza R da 10K
  I = VR/R;
  Rs = Vs/I; // Resistenza di Rs (V/I)
  Ts =1/ (log(Rs/ RT0) / B + 1 / T0); //Ts in K
  Ts = Ts - 273.15; //Conversion to °C
  
  Serial.print("T= ");
  Serial.print(Ts);
  Serial.println(" C");

  if (Ts>=50) {
    Serial.println("Accendo");
    digitalWrite(pinVentola,HIGH);
  }
  else {
    Serial.println("Spengo");
    digitalWrite(pinVentola,LOW);
  }

  delay( 5000 );
}
